/*
 * Decompiled with CFR 0.152.
 */
package info.semanticsoftware.lodexporter;

import com.hp.hpl.jena.datatypes.xsd.XSDDateTime;
import gate.Annotation;
import gate.AnnotationSet;
import gate.Controller;
import gate.FeatureMap;
import gate.ProcessingResource;
import gate.Resource;
import gate.creole.AbstractLanguageAnalyser;
import gate.creole.ControllerAwarePR;
import gate.creole.ExecutionException;
import gate.creole.ResourceInstantiationException;
import gate.creole.metadata.CreoleParameter;
import gate.creole.metadata.CreoleResource;
import gate.creole.metadata.RunTime;
import gate.relations.Relation;
import gate.relations.RelationSet;
import info.semanticsoftware.lodexporter.Mapping;
import info.semanticsoftware.lodexporter.PropertyMapping;
import info.semanticsoftware.lodexporter.RelationMapping;
import info.semanticsoftware.lodexporter.SubjectMapping;
import info.semanticsoftware.lodexporter.TripleStoreInterface;
import info.semanticsoftware.lodexporter.tdb.TDBTripleStoreImpl;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URLEncoder;
import java.util.Calendar;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;
import java.util.UUID;
import org.apache.log4j.Logger;

@CreoleResource(name="LODexporter", comment="An ontology-aware PR to transform GATE annotations to LOD triples.")
public class LODexporter
extends AbstractLanguageAnalyser
implements ProcessingResource,
ControllerAwarePR {
    private static final long serialVersionUID = 1L;
    private Map<String, SubjectMapping> subjectHash;
    private HashMap<String, LinkedList<PropertyMapping>> propertyMapList;
    private HashMap<String, LinkedList<RelationMapping>> relationMapList;
    private TripleStoreInterface myTripleStore;
    private String pipelineName;
    private String corpusName;
    private String sessionID;
    protected static final Logger LOGGER = Logger.getLogger(LODexporter.class);
    @CreoleParameter(comment="RDF store directory", defaultValue="/tmp/tdb")
    private String rdfStoreDir;
    @CreoleParameter(comment="Mapping SPARQL query", defaultValue="SELECT ?rule ?type ?baseURI ?GATEtype WHERE { ?rule ?p <map:Mapping> . ?rule <http://lod.semanticsoftware.info/mapping/mapping#type> ?type . ?rule <http://lod.semanticsoftware.info/mapping/mapping#baseURI> ?baseURI . ?rule <http://lod.semanticsoftware.info/mapping/mapping#GATEtype> ?GATEtype .} ")
    private String subjectMappingSparql;
    @CreoleParameter(comment="PropertyMapping SPARQL query", defaultValue="SELECT ?rule ?GATEtype ?GATEattribute ?GATEfeature ?type WHERE { ?rule ?p <map:Mapping> . ?rule <http://lod.semanticsoftware.info/mapping/mapping#GATEtype> ?GATEtype.?rule <http://lod.semanticsoftware.info/mapping/mapping#hasMapping> ?mapping .?mapping <http://lod.semanticsoftware.info/mapping/mapping#type> ?type . OPTIONAL {?mapping <http://lod.semanticsoftware.info/mapping/mapping#GATEattribute> ?GATEattribute . }OPTIONAL {?mapping <http://lod.semanticsoftware.info/mapping/mapping#GATEfeature> ?GATEfeature . }}")
    private String propertyMappingSparql;
    @CreoleParameter(comment="RelationMapping SPARQL query", defaultValue="SELECT ?rule ?type ?domain ?range ?GATEattribute WHERE { ?rule ?p <map:Mapping> . ?rule <http://lod.semanticsoftware.info/mapping/mapping#type> ?type . ?rule <http://lod.semanticsoftware.info/mapping/mapping#domain> ?domain . ?rule <http://lod.semanticsoftware.info/mapping/mapping#range> ?range . OPTIONAL {?rule <http://lod.semanticsoftware.info/mapping/mapping#GATEattribute> ?GATEattribute . }}")
    private String relationMappingSparql;
    @CreoleParameter(comment="The annotation set to use as input", defaultValue="")
    @RunTime
    private String inputASName;

    public final void setrdfStoreDir(String string) {
        this.rdfStoreDir = string;
    }

    public final String getrdfStoreDir() {
        return this.rdfStoreDir;
    }

    public final String getSubjectMappingSparql() {
        return this.subjectMappingSparql;
    }

    public final void setSubjectMappingSparql(String string) {
        this.subjectMappingSparql = string;
    }

    public final String getPropertyMappingSparql() {
        return this.propertyMappingSparql;
    }

    public final void setPropertyMappingSparql(String string) {
        this.propertyMappingSparql = string;
    }

    public final String getRelationMappingSparql() {
        return this.relationMappingSparql;
    }

    public final void setRelationMappingSparql(String string) {
        this.relationMappingSparql = string;
    }

    public final void setInputASName(String string) {
        this.inputASName = string;
    }

    public final String getInputASName() {
        return this.inputASName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final Resource init() throws ResourceInstantiationException {
        LOGGER.debug((Object)"LODeXporter loaded!");
        this.myTripleStore = new TDBTripleStoreImpl();
        this.myTripleStore.connect(this.getrdfStoreDir());
        try {
            this.myTripleStore.beginTransaction(TripleStoreInterface.TransactionType.WRITE);
            this.myTripleStore.initModel();
            this.subjectHash = this.myTripleStore.getSubjectMappings(this.getSubjectMappingSparql());
            this.propertyMapList = this.myTripleStore.getPropertyMappings(this.getPropertyMappingSparql());
            this.relationMapList = this.myTripleStore.getRelationMappings(this.getRelationMappingSparql());
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        finally {
            this.myTripleStore.endTransaction();
        }
        return this;
    }

    public final void reInit() throws ResourceInstantiationException {
        this.myTripleStore.disconnect();
        this.init();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void execute() throws ExecutionException {
        this.sessionID = UUID.randomUUID().toString();
        String string = (String)this.document.getFeatures().get((Object)"gate.SourceURL");
        string = this.fixProtocol(string);
        try {
            this.myTripleStore.beginTransaction(TripleStoreInterface.TransactionType.WRITE);
            this.myTripleStore.storeTriple(string, "http://ssl.info/Corpus/" + this.corpusName);
            AnnotationSet annotationSet = this.inputASName == null || this.inputASName.trim().length() == 0 ? this.document.getAnnotations() : this.document.getAnnotations(this.inputASName);
            HashMap<String, Object> hashMap = new HashMap<String, Object>();
            HashMap<String, Object> hashMap2 = new HashMap<String, Object>();
            for (SubjectMapping subjectMapping : this.subjectHash.values()) {
                AnnotationSet annotationSet2 = annotationSet.get(subjectMapping.getGATEType());
                String string2 = subjectMapping.getRule();
                List list = this.propertyMapList.get(string2);
                List list2 = this.relationMapList.get(string2);
                LOGGER.debug((Object)("Mapping " + subjectMapping.getGATEType() + " with props: " + list + " and relations " + list2 + " for rule: " + string2));
                for (Annotation annotation : annotationSet2) {
                    hashMap.clear();
                    hashMap2.clear();
                    FeatureMap featureMap = annotation.getFeatures();
                    this.processProperties(string, list, annotation, hashMap, featureMap);
                    this.myTripleStore.storeTriple(string, this.getURIforAnnotation(annotation, subjectMapping.getBaseURI(), this.sessionID, string2), subjectMapping.getType(), hashMap, this.propertyMapList);
                    this.processRelations(string, list2, annotation, hashMap2, subjectMapping, this.sessionID);
                }
            }
            this.processRelationsAdHoc(string, "");
        }
        catch (Exception exception) {
            LOGGER.error((Object)("Error in processing document " + this.document.getName()), (Throwable)exception);
        }
        finally {
            this.myTripleStore.endTransaction();
        }
    }

    private void processRelationsAdHoc(String string, String string2) {
        RelationSet relationSet = this.document.getAnnotations(string2).getRelations();
        String string3 = null;
        String string4 = null;
        for (Relation relation : relationSet) {
            String string5 = this.getURIforRelation(relation, "http://semanticsoftware.info/lodexporter/", relation.getType());
            int[] nArray = relation.getMembers();
            if (nArray.length == 2) {
                Annotation annotation = this.document.getAnnotations().get(Integer.valueOf(nArray[0]));
                Annotation annotation2 = this.document.getAnnotations().get(Integer.valueOf(nArray[1]));
                for (SubjectMapping subjectMapping : this.subjectHash.values()) {
                    if (subjectMapping.getGATEType().equals(annotation.getType())) {
                        string3 = this.getURIforAnnotation(annotation, subjectMapping.getBaseURI(), this.sessionID, subjectMapping.getRule());
                        continue;
                    }
                    if (!subjectMapping.getGATEType().equals(annotation2.getType())) continue;
                    string4 = this.getURIforAnnotation(annotation2, subjectMapping.getBaseURI(), this.sessionID, subjectMapping.getRule());
                }
                this.myTripleStore.storeTriple(string, string5, relation.getFeatures(), string3, string4);
                continue;
            }
            System.out.println("This relation does not have two members. Skipping relation #" + relation.getId());
        }
    }

    private String getURIforRelation(Relation relation, String string, String string2) {
        String string3 = relation.getId().toString();
        return string + this.sessionID + "/" + relation.getType() + "/" + string3 + "#" + string2;
    }

    private void processRelations(String string, List<RelationMapping> list, Annotation annotation, HashMap<String, Object> hashMap, SubjectMapping subjectMapping, String string2) {
        if (list != null) {
            for (RelationMapping relationMapping : list) {
                Object object;
                if (relationMapping.getGATEattribute() != null && relationMapping.getGATEattribute().equals("contains")) {
                    object = this.subjectHash.get(relationMapping.getRange());
                    String string3 = ((Mapping)object).getGATEType();
                    String string4 = ((SubjectMapping)object).getBaseURI();
                    String string5 = ((Mapping)object).getRule();
                    AnnotationSet annotationSet = this.document.getAnnotations().getContained(annotation.getStartNode().getOffset(), annotation.getEndNode().getOffset()).get(string3);
                    for (Annotation annotation2 : annotationSet) {
                        String string6 = this.getURIforAnnotation(annotation2, string4, string2, string5);
                        this.myTripleStore.storeTriple(string, relationMapping, this.getURIforAnnotation(annotation, subjectMapping.getBaseURI(), string2, relationMapping.getDomain()), string6);
                    }
                    continue;
                }
                object = this.getURIforAnnotation(annotation, subjectMapping.getBaseURI(), string2, relationMapping.getRange());
                this.myTripleStore.storeTriple(string, relationMapping, this.getURIforAnnotation(annotation, subjectMapping.getBaseURI(), string2, relationMapping.getDomain()), (String)object);
            }
        }
    }

    private void processProperties(String string, List<PropertyMapping> list, Annotation annotation, HashMap<String, Object> hashMap, FeatureMap featureMap) throws ExecutionException {
        if (list != null) {
            for (PropertyMapping propertyMapping : list) {
                if (propertyMapping.getGATEfeature() != null && propertyMapping.getGATEattribute() != null) {
                    throw new ExecutionException("Both GATE feature and attributes have values.");
                }
                if (propertyMapping.getGATEfeature() != null) {
                    if (!featureMap.containsKey((Object)propertyMapping.getGATEfeature())) continue;
                    Object object = featureMap.get((Object)propertyMapping.getGATEfeature());
                    if (object != null) {
                        hashMap.put(propertyMapping.getGATEfeature(), object);
                        continue;
                    }
                    System.err.println("WARNING: " + propertyMapping.getGATEfeature() + " has a NULL value in document (" + string + ") for annotation #" + annotation.getId() + ". I'm going to skip exporting this feature.");
                    continue;
                }
                if (propertyMapping.getGATEattribute() != null) {
                    hashMap.put(propertyMapping.getGATEattribute(), this.getValueforGATEAttribute(propertyMapping.getGATEattribute(), annotation));
                    continue;
                }
                throw new ExecutionException("Both GATE feature and attributes are null.");
            }
        }
    }

    private Object getValueforGATEAttribute(String string, Annotation annotation) {
        Object object = null;
        try {
            switch (string) {
                case "content": {
                    object = this.document.getContent().getContent(annotation.getStartNode().getOffset(), annotation.getEndNode().getOffset()).toString();
                    break;
                }
                case "startOffset": {
                    object = annotation.getStartNode().getOffset();
                    break;
                }
                case "endOffset": {
                    object = annotation.getEndNode().getOffset();
                    break;
                }
                case "docURL": {
                    object = new URI((String)this.document.getFeatures().get((Object)"gate.SourceURL"));
                    break;
                }
                case "annotatedAt": {
                    object = new XSDDateTime(Calendar.getInstance(TimeZone.getTimeZone("America/Montreal")));
                    break;
                }
                case "annotatedBy": {
                    object = this.pipelineName;
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unsuppport GATE attribute: " + string);
                }
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw illegalArgumentException;
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return object;
    }

    private String getURIforAnnotation(Annotation annotation, String string, String string2, String string3) {
        String string4 = annotation.getId().toString();
        return string + string2 + "/" + annotation.getType() + "/" + string4 + "#" + string3;
    }

    private String fixProtocol(String string) {
        return string.replaceFirst("file:\\/", "http://");
    }

    public final void controllerExecutionAborted(Controller controller, Throwable throwable) throws ExecutionException {
    }

    public final void controllerExecutionFinished(Controller controller) throws ExecutionException {
        LOGGER.debug((Object)("[controllerExecutionFinished] Dataset is now: " + this.myTripleStore.printDataset()));
    }

    public final void controllerExecutionStarted(Controller controller) throws ExecutionException {
        this.pipelineName = controller.getName();
        try {
            this.corpusName = URLEncoder.encode(this.corpus.getName(), "UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            unsupportedEncodingException.printStackTrace();
        }
        LOGGER.debug((Object)("[controllerExecutionStarted] Dataset is now: " + this.myTripleStore.printDataset()));
    }
}

