/*
 * Decompiled with CFR 0.152.
 */
package info.semanticsoftware.lodexporter.tdb;

import com.hp.hpl.jena.query.Dataset;
import com.hp.hpl.jena.query.QueryExecution;
import com.hp.hpl.jena.query.QueryExecutionFactory;
import com.hp.hpl.jena.query.QuerySolution;
import com.hp.hpl.jena.query.ReadWrite;
import com.hp.hpl.jena.query.ResultSet;
import com.hp.hpl.jena.rdf.model.Literal;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.Property;
import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.tdb.TDBFactory;
import com.hp.hpl.jena.vocabulary.RDF;
import gate.FeatureMap;
import info.semanticsoftware.lodexporter.PropertyMapping;
import info.semanticsoftware.lodexporter.RelationMapping;
import info.semanticsoftware.lodexporter.SubjectMapping;
import info.semanticsoftware.lodexporter.TripleStoreInterface;
import java.net.URI;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import org.apache.commons.lang.NullArgumentException;
import org.apache.log4j.Logger;

public class TDBTripleStoreImpl
implements TripleStoreInterface {
    private Dataset dataset;
    private Model model;
    private HashMap<String, Property> propertyModelHash;
    private HashMap<String, Property> relationModelHash;
    private final String modelBaseURI = "http://lod.semanticsoftware.info/pubo/pubo#";
    private Property hasAnnotation;
    private Property hasDocument;
    private Property hasCompetencyRecord;
    private Property competenceFor;
    protected static final Logger LOGGER = Logger.getLogger(TDBTripleStoreImpl.class);

    @Override
    public void connect(String string) {
        this.dataset = TDBFactory.createDataset((String)string);
        LOGGER.debug((Object)("[connect] Dataset is now: " + this.dataset));
    }

    @Override
    public void disconnect() {
        this.dataset.close();
        TDBFactory.reset();
        LOGGER.debug((Object)("[disconnect] Dataset is now: " + this.dataset));
    }

    @Override
    public void beginTransaction(TripleStoreInterface.TransactionType transactionType2) {
        if (transactionType2 == TripleStoreInterface.TransactionType.READ) {
            this.dataset.begin(ReadWrite.READ);
        } else {
            this.dataset.begin(ReadWrite.WRITE);
        }
    }

    @Override
    public void endTransaction() {
        this.dataset.commit();
        this.dataset.end();
    }

    @Override
    public Map<String, SubjectMapping> getSubjectMappings(String string) throws Exception {
        Map<String, SubjectMapping> map = null;
        ResultSet resultSet = this.queryMappings(string);
        map = this.populateSubjectHash(resultSet);
        return map;
    }

    @Override
    public HashMap<String, LinkedList<PropertyMapping>> getPropertyMappings(String string) throws Exception {
        HashMap<String, LinkedList<PropertyMapping>> hashMap = null;
        ResultSet resultSet = this.queryMappings(string);
        hashMap = this.populatePropertyMapList(resultSet);
        this.prepareTDBPropertyModel(hashMap);
        return hashMap;
    }

    @Override
    public HashMap<String, LinkedList<RelationMapping>> getRelationMappings(String string) throws Exception {
        HashMap<String, LinkedList<RelationMapping>> hashMap = null;
        ResultSet resultSet = this.queryMappings(string);
        hashMap = this.populateRelationMapList(resultSet);
        this.prepareTDBRelationModel(hashMap);
        return hashMap;
    }

    private ResultSet queryMappings(String string) throws Exception {
        QueryExecution queryExecution = QueryExecutionFactory.create((String)string, (Dataset)this.dataset);
        ResultSet resultSet = queryExecution.execSelect();
        return resultSet;
    }

    private Map<String, SubjectMapping> populateSubjectHash(ResultSet resultSet) {
        HashMap<String, SubjectMapping> hashMap = new HashMap<String, SubjectMapping>();
        try {
            while (resultSet.hasNext()) {
                QuerySolution querySolution = resultSet.nextSolution();
                RDFNode rDFNode = querySolution.get("?rule");
                String string = null;
                if (rDFNode != null) {
                    string = rDFNode.asResource().getURI();
                }
                RDFNode rDFNode2 = querySolution.get("?baseURI");
                String string2 = null;
                if (rDFNode2 != null) {
                    string2 = rDFNode2.asResource().getURI();
                }
                RDFNode rDFNode3 = querySolution.get("?GATEtype");
                String string3 = null;
                if (rDFNode3 != null) {
                    string3 = rDFNode3.asLiteral().getString();
                }
                RDFNode rDFNode4 = querySolution.get("?type");
                String string4 = null;
                if (rDFNode4 != null) {
                    string4 = rDFNode4.asResource().getURI();
                }
                SubjectMapping subjectMapping = new SubjectMapping(string, string2, string4, string3);
                hashMap.put(string, subjectMapping);
            }
        }
        catch (Exception exception) {
            LOGGER.error((Object)"Error reading the subject mappings.", (Throwable)exception);
        }
        LOGGER.debug((Object)("----- SUBJECT MAPLIST: " + hashMap));
        return hashMap;
    }

    private HashMap<String, LinkedList<PropertyMapping>> populatePropertyMapList(ResultSet resultSet) {
        HashMap<String, LinkedList<PropertyMapping>> hashMap = new HashMap<String, LinkedList<PropertyMapping>>();
        try {
            while (resultSet.hasNext()) {
                QuerySolution querySolution = resultSet.nextSolution();
                RDFNode rDFNode = querySolution.get("?rule");
                String string = null;
                if (rDFNode != null) {
                    string = rDFNode.asResource().getURI();
                }
                RDFNode rDFNode2 = querySolution.get("?GATEtype");
                String string2 = null;
                if (rDFNode2 != null) {
                    string2 = rDFNode2.asLiteral().getString();
                }
                RDFNode rDFNode3 = querySolution.get("?GATEfeature");
                String string3 = null;
                if (rDFNode3 != null) {
                    string3 = rDFNode3.asLiteral().getString();
                }
                RDFNode rDFNode4 = querySolution.get("?GATEattribute");
                String string4 = null;
                if (rDFNode4 != null) {
                    string4 = rDFNode4.asLiteral().getString();
                }
                RDFNode rDFNode5 = querySolution.get("?type");
                String string5 = null;
                if (rDFNode5 != null) {
                    string5 = this.model.expandPrefix(rDFNode5.asResource().getURI());
                }
                PropertyMapping propertyMapping = new PropertyMapping(string, string5, string2, string3, string4);
                if (hashMap.containsKey(string)) {
                    hashMap.get(string).add(propertyMapping);
                    continue;
                }
                LinkedList<PropertyMapping> linkedList = new LinkedList<PropertyMapping>();
                linkedList.add(propertyMapping);
                hashMap.put(string, linkedList);
            }
        }
        catch (Exception exception) {
            LOGGER.error((Object)"Error populating the property hashmap.", (Throwable)exception);
        }
        LOGGER.debug((Object)("----- PROPERTY HASHMAP:" + hashMap));
        return hashMap;
    }

    private HashMap<String, LinkedList<RelationMapping>> populateRelationMapList(ResultSet resultSet) {
        HashMap<String, LinkedList<RelationMapping>> hashMap = new HashMap<String, LinkedList<RelationMapping>>();
        try {
            while (resultSet.hasNext()) {
                QuerySolution querySolution = resultSet.nextSolution();
                RDFNode rDFNode = querySolution.get("?rule");
                String string = null;
                if (rDFNode != null) {
                    string = rDFNode.asResource().getURI();
                }
                RDFNode rDFNode2 = querySolution.get("?domain");
                String string2 = null;
                if (rDFNode2 == null) {
                    throw new NullArgumentException("Missing domain for rule: " + string);
                }
                string2 = rDFNode2.asResource().getURI();
                RDFNode rDFNode3 = querySolution.get("?range");
                String string3 = null;
                if (rDFNode3 == null) {
                    throw new NullArgumentException("Missing range for rule: " + string);
                }
                string3 = rDFNode3.asResource().getURI();
                RDFNode rDFNode4 = querySolution.get("?type");
                String string4 = null;
                if (rDFNode4 != null) {
                    string4 = this.model.expandPrefix(rDFNode4.asResource().getURI());
                }
                RDFNode rDFNode5 = querySolution.get("?GATEattribute");
                String string5 = null;
                if (rDFNode5 != null) {
                    string5 = rDFNode5.asLiteral().getString();
                }
                RelationMapping relationMapping = new RelationMapping(string, string4, string2, string3, string5);
                if (hashMap.containsKey(string2)) {
                    hashMap.get(string2).add(relationMapping);
                    continue;
                }
                LinkedList<RelationMapping> linkedList = new LinkedList<RelationMapping>();
                linkedList.add(relationMapping);
                hashMap.put(string2, linkedList);
            }
        }
        catch (Exception exception) {
            LOGGER.error((Object)"Error populating the relation hashmap.", (Throwable)exception);
        }
        LOGGER.debug((Object)("----- RELATION HASHMAP:" + hashMap));
        return hashMap;
    }

    @Override
    public void initModel() {
        this.model = this.dataset.getDefaultModel();
    }

    private void prepareTDBPropertyModel(HashMap<String, LinkedList<PropertyMapping>> hashMap) {
        this.hasAnnotation = this.model.createProperty("http://lod.semanticsoftware.info/pubo/pubo#", "hasAnnotation");
        this.hasDocument = this.model.createProperty("http://lod.semanticsoftware.info/pubo/pubo#", "hasDocument");
        this.hasCompetencyRecord = this.model.createProperty("http://intelleo.eu/ontologies/user-model/ns/", "hasCompetencyRecord");
        this.competenceFor = this.model.createProperty("http://www.intelleo.eu/ontologies/competences/ns/", "competenceFor");
        this.propertyModelHash = new HashMap();
        for (LinkedList<PropertyMapping> linkedList : hashMap.values()) {
            for (PropertyMapping propertyMapping : linkedList) {
                String string = propertyMapping.getGATEattribute() == null ? propertyMapping.getGATEfeature() : propertyMapping.getGATEattribute();
                this.propertyModelHash.put(string, this.model.createProperty(propertyMapping.getType()));
            }
        }
    }

    private void prepareTDBRelationModel(HashMap<String, LinkedList<RelationMapping>> hashMap) {
        this.model = this.dataset.getDefaultModel();
        this.relationModelHash = new HashMap();
        for (LinkedList<RelationMapping> linkedList : hashMap.values()) {
            for (RelationMapping relationMapping : linkedList) {
                this.relationModelHash.put(relationMapping.getRule(), this.model.createProperty(relationMapping.getType()));
            }
        }
    }

    @Override
    public void storeTriple(String string, String string2, String string3, HashMap<String, Object> hashMap, HashMap<String, LinkedList<PropertyMapping>> hashMap2) {
        try {
            this.model = this.dataset.getDefaultModel();
            Resource resource = this.model.createResource(this.model.expandPrefix(string2));
            for (String string4 : hashMap.keySet()) {
                if (hashMap.get(string4).getClass() == URI.class) {
                    resource.addProperty(this.propertyModelHash.get(string4), (RDFNode)this.model.createResource(hashMap.get(string4).toString()));
                    continue;
                }
                if ("URI".equals(string4) || "URI1".equals(string4)) {
                    resource.addProperty(this.propertyModelHash.get(string4), (RDFNode)this.model.createResource((String)hashMap.get(string4)));
                    continue;
                }
                Literal literal = this.model.createTypedLiteral(hashMap.get(string4));
                resource.addProperty(this.propertyModelHash.get(string4), (RDFNode)literal);
            }
            resource.addProperty(RDF.type, (RDFNode)this.model.createResource(this.model.expandPrefix(string3)));
            this.model.createResource(string).addProperty(this.hasAnnotation, (RDFNode)resource);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            System.err.println(string + ", " + string2 + ", " + string3);
            System.err.println(hashMap2);
        }
    }

    @Override
    public void storeTriple(String string, RelationMapping relationMapping, String string2, String string3) {
        try {
            this.model = this.dataset.getDefaultModel();
            Resource resource = this.model.createResource(string2);
            resource.addProperty(this.relationModelHash.get(relationMapping.getRule()), (RDFNode)this.model.createResource(string3));
        }
        catch (Exception exception) {
            exception.printStackTrace();
            System.err.println(string + ", " + string2 + ", " + string3);
        }
    }

    @Override
    public void storeTriple(String string, String string2, FeatureMap featureMap, String string3, String string4) {
        try {
            this.model = this.dataset.getDefaultModel();
            Resource resource = this.model.createResource(string2);
            resource.addProperty(RDF.type, (RDFNode)this.model.createResource((String)featureMap.get((Object)"type")));
            resource.addProperty(this.competenceFor, (RDFNode)this.model.createResource(string4));
            this.model.createResource(string3).addProperty(this.hasCompetencyRecord, (RDFNode)resource);
            this.model.createResource(string).addProperty(this.hasAnnotation, (RDFNode)resource);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    @Override
    public void storeTriple(String string, String string2) {
        try {
            this.model = this.dataset.getDefaultModel();
            this.model.createResource(string2).addProperty(this.hasDocument, (RDFNode)this.model.createResource(string));
            System.out.println("Exported " + string2 + " hasDocument " + string);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    @Override
    public final String printDataset() {
        return this.dataset.toString();
    }
}

