/*
 * Decompiled with CFR 0.152.
 */
package gate.configurableexporter;

import gate.Annotation;
import gate.AnnotationSet;
import gate.Document;
import gate.ProcessingResource;
import gate.Resource;
import gate.Utils;
import gate.creole.AbstractLanguageAnalyser;
import gate.creole.ExecutionException;
import gate.creole.ResourceInstantiationException;
import gate.creole.metadata.CreoleParameter;
import gate.creole.metadata.CreoleResource;
import gate.creole.metadata.Optional;
import gate.creole.metadata.RunTime;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.io.Serializable;
import java.net.URL;
import java.util.List;

@CreoleResource(name="Configurable Exporter", comment="Allows annotations to be exported according to a specified format.")
public class ConfigurableExporter
extends AbstractLanguageAnalyser
implements ProcessingResource,
Serializable {
    private static final long serialVersionUID = -7237223509897088067L;
    private URL configFileURL;
    private URL outputURL;
    private String inputASName;
    private String instanceName;
    private int numberOfAnnotationSlots = -1;
    private int numberOfBridgeTextSlots = -1;
    private static int maxslotsno = 50;
    private String[][] annsToInsert = new String[maxslotsno][2];
    private String[] bridges = new String[maxslotsno];
    private PrintStream outputStream = System.out;

    @CreoleParameter(comment="The configuration file specifying output format.", defaultValue="resources/configurableexporter/example.conf", suffixes=".conf")
    public void setConfigFileURL(URL configFileURL) {
        this.configFileURL = configFileURL;
    }

    public URL getConfigFileURL() {
        return this.configFileURL;
    }

    @RunTime
    @Optional
    @CreoleParameter(comment="The file to which data will be output. Leave blank for output to messages tab or standard out.")
    public void setOutputURL(URL output) {
        this.outputURL = output;
        this.outputStream = System.out;
        if (this.outputURL != null) {
            try {
                this.outputStream = new PrintStream(this.outputURL.getFile());
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public URL getOutputURL() {
        return this.outputURL;
    }

    @RunTime
    @Optional
    @CreoleParameter(comment="The name for annotation set used as input to the exporter.")
    public void setInputASName(String iasn) {
        this.inputASName = iasn;
    }

    public String getInputASName() {
        return this.inputASName;
    }

    @RunTime
    @Optional
    @CreoleParameter(comment="The annotation type to be treated as instance. Leave blank to use document as instance.")
    public void setInstanceName(String inst) {
        this.instanceName = inst;
    }

    public String getInstanceName() {
        return this.instanceName;
    }

    public Resource init() throws ResourceInstantiationException {
        this.numberOfAnnotationSlots = -1;
        this.numberOfBridgeTextSlots = -1;
        this.annsToInsert = new String[maxslotsno][2];
        this.bridges = new String[maxslotsno];
        if (this.configFileURL == null) {
            throw new IllegalArgumentException("No value provided for the configFileURL parameter");
        }
        String strLine = null;
        try {
            BufferedReader in = new BufferedReader(new InputStreamReader(this.configFileURL.openStream()));
            strLine = in.readLine();
            if (strLine != null) {
                int upto = 0;
                for (int thisSlot = 0; upto < strLine.length() && thisSlot < maxslotsno; ++thisSlot) {
                    int startAnnoName = strLine.indexOf("{", upto);
                    int endAnnoName = strLine.indexOf("}", upto);
                    if (startAnnoName == -1 && endAnnoName == -1) {
                        this.bridges[thisSlot] = strLine.substring(upto, strLine.length());
                        this.numberOfBridgeTextSlots = thisSlot + 1;
                        upto = strLine.length();
                        continue;
                    }
                    if (startAnnoName == -1 && endAnnoName != -1 || startAnnoName != -1 && endAnnoName == -1) {
                        throw new ResourceInstantiationException("Failed to parse configuration file for Configurable Exporter.");
                    }
                    this.bridges[thisSlot] = strLine.substring(upto, startAnnoName);
                    String thisAnnToInsert = strLine.substring(startAnnoName + 1, endAnnoName);
                    String[] annotationTypeAndFeature = thisAnnToInsert.split("\\.", 2);
                    this.annsToInsert[thisSlot][0] = annotationTypeAndFeature[0];
                    this.annsToInsert[thisSlot][1] = annotationTypeAndFeature.length == 2 ? annotationTypeAndFeature[1] : null;
                    upto = endAnnoName + 1;
                    this.numberOfAnnotationSlots = thisSlot + 1;
                    this.numberOfBridgeTextSlots = thisSlot + 1;
                }
            }
        }
        catch (Exception e) {
            System.out.println("Failed to access configuration file.");
            e.printStackTrace();
        }
        return this;
    }

    public void execute() throws ExecutionException {
        Document doc = this.getDocument();
        AnnotationSet inputAS = null;
        inputAS = this.inputASName == null || this.inputASName.equals("") ? doc.getAnnotations() : doc.getAnnotations(this.inputASName);
        List instances = null;
        if (this.instanceName == null || this.instanceName.equals("")) {
            for (int i = 0; i < this.numberOfAnnotationSlots; ++i) {
                List typedAnnotations;
                this.outputStream.print(this.bridges[i]);
                if (this.annsToInsert[i][0] == null || (typedAnnotations = Utils.inDocumentOrder((AnnotationSet)inputAS.get(this.annsToInsert[i][0]))).size() <= 0) continue;
                Annotation annotationToPrint = (Annotation)typedAnnotations.get(0);
                if (this.annsToInsert[i][1] != null) {
                    this.outputStream.print(annotationToPrint.getFeatures().get((Object)this.annsToInsert[i][1]));
                    continue;
                }
                long startNode = annotationToPrint.getStartNode().getOffset();
                long endNode = annotationToPrint.getEndNode().getOffset();
                String annotationText = "";
                try {
                    annotationText = doc.getContent().getContent(Long.valueOf(startNode), Long.valueOf(endNode)).toString();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                this.outputStream.print(annotationText);
            }
            if (this.numberOfBridgeTextSlots > this.numberOfAnnotationSlots) {
                this.outputStream.print(this.bridges[this.numberOfBridgeTextSlots - 1]);
            }
            this.outputStream.println();
        } else {
            instances = Utils.inDocumentOrder((AnnotationSet)inputAS.get(this.instanceName));
            for (Annotation thisInstanceAnnotation : instances) {
                long startSearch = thisInstanceAnnotation.getStartNode().getOffset();
                long endSearch = thisInstanceAnnotation.getEndNode().getOffset();
                for (int i = 0; i < this.numberOfAnnotationSlots; ++i) {
                    this.outputStream.print(this.bridges[i]);
                    List typedAnnotations = Utils.inDocumentOrder((AnnotationSet)inputAS.get(this.annsToInsert[i][0], Long.valueOf(startSearch), Long.valueOf(endSearch)));
                    if (typedAnnotations.size() <= 0) continue;
                    Annotation annotationToPrint = (Annotation)typedAnnotations.get(0);
                    if (this.annsToInsert[i][1] != null) {
                        this.outputStream.print(annotationToPrint.getFeatures().get((Object)this.annsToInsert[i][1]));
                        continue;
                    }
                    long startNode = annotationToPrint.getStartNode().getOffset();
                    long endNode = annotationToPrint.getEndNode().getOffset();
                    String annotationText = "";
                    try {
                        annotationText = doc.getContent().getContent(Long.valueOf(startNode), Long.valueOf(endNode)).toString();
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    this.outputStream.print(annotationText);
                }
                if (this.numberOfBridgeTextSlots > this.numberOfAnnotationSlots) {
                    this.outputStream.print(this.bridges[this.numberOfBridgeTextSlots - 1]);
                }
                this.outputStream.println();
            }
        }
    }

    public synchronized void interrupt() {
        super.interrupt();
    }
}

