/*
 * Decompiled with CFR 0.152.
 */
package gate.qa;

import gate.Annotation;
import gate.Document;
import gate.SimpleAnnotation;
import gate.Utils;
import gate.util.AnnotationDiffer;
import gate.util.Strings;
import java.awt.Color;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.text.NumberFormat;
import java.util.List;
import java.util.Map;

public class AnnotationDiffExporter {
    private String keySetName;
    private String respSetName;
    protected Document document;
    protected Map<AnnotationDiffer, List<AnnotationDiffer.Pairing>> differs;

    public AnnotationDiffExporter(Map<AnnotationDiffer, List<AnnotationDiffer.Pairing>> differs, Document document, String keySetName, String respSetName) {
        this.differs = differs;
        this.document = document;
        this.keySetName = keySetName;
        this.respSetName = respSetName;
    }

    public void export(File destinationFile) throws IOException {
        String docName = this.document.getName();
        String nl = Strings.getNl();
        BufferedWriter fw = new BufferedWriter(new FileWriter(destinationFile));
        fw.write("<html><body>");
        fw.write("<H2>Annotation Diff - comparing annotations! </H2>");
        fw.write("<TABLE cellpadding=\"5\" border=\"0\"");
        fw.write(nl);
        fw.write("<TR>" + nl);
        fw.write("\t<TH align=\"left\">&nbsp;</TH>" + nl);
        fw.write("\t<TH align=\"left\">Document</TH>" + nl);
        fw.write("\t<TH align=\"left\">Annotation Set</TH>" + nl);
        fw.write("</TR>" + nl);
        fw.write("<TR>" + nl);
        fw.write("\t<TH align=\"left\">Key</TH>" + nl);
        fw.write("\t<TD align=\"left\">" + docName + "</TD>" + nl);
        fw.write("\t<TD align=\"left\">" + this.keySetName + "</TD>" + nl);
        fw.write("</TR>" + nl);
        fw.write("<TR>" + nl);
        fw.write("\t<TH align=\"left\">Response</TH>" + nl);
        fw.write("\t<TD align=\"left\">" + docName + "</TD>" + nl);
        fw.write("\t<TD align=\"left\">" + this.respSetName + "</TD>" + nl);
        fw.write("</TR>" + nl);
        fw.write("</TABLE>" + nl);
        fw.write("<BR><BR><BR>" + nl);
        fw.write("<HR/>");
        for (AnnotationDiffer differ : this.differs.keySet()) {
            List<AnnotationDiffer.Pairing> pairings = this.differs.get(differ);
            DiffTable diffTable = new DiffTable(pairings);
            fw.write("<H2>" + differ.getAnnotationType() + " annotations" + "</H2>");
            NumberFormat format = NumberFormat.getInstance();
            format.setMaximumFractionDigits(4);
            fw.write("Recall: " + format.format(differ.getRecallStrict()) + "<br>" + nl);
            fw.write("Precision: " + format.format(differ.getPrecisionStrict()) + "<br>" + nl);
            fw.write("F-measure: " + format.format(differ.getFMeasureStrict(1.0)) + "<br>" + nl);
            fw.write("<br>");
            fw.write("Correct: " + differ.getCorrectMatches() + "<br>" + nl);
            fw.write("Partially correct: " + differ.getPartiallyCorrectMatches() + "<br>" + nl);
            fw.write("Missing: " + differ.getMissing() + "<br>" + nl);
            fw.write("False positives: " + differ.getSpurious() + "<br>" + nl);
            fw.write("<table cellpadding=\"0\" border=\"1\">" + nl + "<TR>" + nl);
            int maxColIdx = diffTable.getColumnCount() - 1;
            for (int col = 0; col <= maxColIdx; ++col) {
                fw.write("\t<TH align=\"left\">" + diffTable.getColumnName(col) + "</TH>" + nl);
            }
            fw.write("</TR>");
            int rowCnt = diffTable.getRowCount();
            for (int row = 0; row < rowCnt; ++row) {
                fw.write("<TR>");
                for (int col = 0; col <= maxColIdx; ++col) {
                    Color bgCol = diffTable.getBackgroundAt(row, col);
                    fw.write("\t<TD bgcolor=\"#" + Integer.toHexString(bgCol.getRGB()).substring(2) + "\">" + diffTable.getValueAt(row, col) + "</TD>" + nl);
                }
                fw.write("</TR>");
            }
            fw.write("</table><br><br>");
            fw.write("<HR/>");
        }
        fw.write("</body></html>");
        ((Writer)fw).flush();
        ((Writer)fw).close();
    }

    class DiffTable {
        private final int COL_COUNT = 9;
        private final int COL_KEY_START = 0;
        private final int COL_KEY_END = 1;
        private final int COL_KEY_STRING = 2;
        private final int COL_KEY_FEATURES = 3;
        private final int COL_MATCH = 4;
        private final int COL_RES_START = 5;
        private final int COL_RES_END = 6;
        private final int COL_RES_STRING = 7;
        private final int COL_RES_FEATURES = 8;
        private final Color BG = Color.WHITE;
        private final Color PARTIALLY_CORRECT_BG = new Color(173, 215, 255);
        private final Color MISSING_BG = new Color(255, 173, 181);
        private final Color FALSE_POSITIVE_BG = new Color(255, 231, 173);
        private String[] matchLabel = new String[5];
        private final int maxCellLength = 40;
        private List<AnnotationDiffer.Pairing> pairings;

        public DiffTable(List<AnnotationDiffer.Pairing> pairings) {
            this.matchLabel[0] = "=";
            this.matchLabel[1] = "~";
            this.matchLabel[2] = "-?";
            this.matchLabel[3] = "?-";
            this.matchLabel[4] = "<>";
            this.pairings = pairings;
        }

        public int getRowCount() {
            return this.pairings.size();
        }

        public int getColumnCount() {
            return 9;
        }

        public String getColumnName(int column) {
            switch (column) {
                case 0: {
                    return "Start";
                }
                case 1: {
                    return "End";
                }
                case 2: {
                    return "Key";
                }
                case 3: {
                    return "Features";
                }
                case 4: {
                    return "=?";
                }
                case 5: {
                    return "Start";
                }
                case 6: {
                    return "End";
                }
                case 7: {
                    return "Response";
                }
                case 8: {
                    return "Features";
                }
            }
            return "?";
        }

        public Color getBackgroundAt(int row, int column) {
            AnnotationDiffer.Pairing pairing = this.pairings.get(row);
            switch (pairing.getType()) {
                case 0: {
                    return this.BG;
                }
                case 1: {
                    return this.PARTIALLY_CORRECT_BG;
                }
                case 4: {
                    if (column < 4) {
                        return this.MISSING_BG;
                    }
                    if (column > 4) {
                        return this.FALSE_POSITIVE_BG;
                    }
                    return this.BG;
                }
                case 2: {
                    return this.MISSING_BG;
                }
                case 3: {
                    return this.FALSE_POSITIVE_BG;
                }
            }
            return this.BG;
        }

        public Object getValueAt(int row, int column) {
            AnnotationDiffer.Pairing pairing = this.pairings.get(row);
            Annotation key = pairing.getKey();
            Annotation res = pairing.getResponse();
            switch (column) {
                case 0: {
                    return key == null ? "" : key.getStartNode().getOffset().toString();
                }
                case 1: {
                    return key == null ? "" : key.getEndNode().getOffset().toString();
                }
                case 2: {
                    String keyStr = "";
                    if (key != null && AnnotationDiffExporter.this.document != null) {
                        keyStr = Utils.stringFor((Document)AnnotationDiffExporter.this.document, (SimpleAnnotation)key);
                    }
                    if (keyStr.length() > 40) {
                        keyStr = keyStr.substring(0, 20) + "..." + keyStr.substring(keyStr.length() - 20);
                    }
                    keyStr = keyStr.replaceAll("(?:\r?\n)|\r", "\u2193");
                    keyStr = keyStr.replaceAll("\t", "\u2192");
                    keyStr = keyStr.replaceAll(" ", "\u00b7");
                    return keyStr;
                }
                case 3: {
                    return key == null ? "" : key.getFeatures().toString();
                }
                case 4: {
                    return this.matchLabel[pairing.getType()];
                }
                case 5: {
                    return res == null ? "" : res.getStartNode().getOffset().toString();
                }
                case 6: {
                    return res == null ? "" : res.getEndNode().getOffset().toString();
                }
                case 7: {
                    String resStr = "";
                    if (res != null && AnnotationDiffExporter.this.document != null) {
                        resStr = Utils.stringFor((Document)AnnotationDiffExporter.this.document, (SimpleAnnotation)res);
                    }
                    if (resStr.length() > 40) {
                        resStr = resStr.substring(0, 20) + "..." + resStr.substring(resStr.length() - 20);
                    }
                    resStr = resStr.replaceAll("(?:\r?\n)|\r", "\u2193");
                    resStr = resStr.replaceAll("\t", "\u2192");
                    resStr = resStr.replaceAll(" ", "\u00b7");
                    return resStr;
                }
                case 8: {
                    return res == null ? "" : res.getFeatures().toString();
                }
            }
            return "?";
        }
    }
}

