/*
 * Decompiled with CFR 0.152.
 */
package gate.qa;

import gate.AnnotationSet;
import gate.Document;
import gate.Factory;
import gate.ProcessingResource;
import gate.Resource;
import gate.creole.AbstractLanguageAnalyser;
import gate.creole.ExecutionException;
import gate.creole.ResourceInstantiationException;
import gate.creole.metadata.CreoleParameter;
import gate.creole.metadata.CreoleResource;
import gate.creole.metadata.Optional;
import gate.creole.metadata.RunTime;
import gate.creole.ontology.InvalidURIException;
import gate.qa.AnnotationDiffExporter;
import gate.qa.Measure;
import gate.util.AnnotationDiffer;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.net.URISyntaxException;
import java.net.URL;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;

@CreoleResource(name="Quality Assurance PR", comment="The Quality Assurance PR provides a functionality of the Corpus QA Tool in GATE Developer")
public class QualityAssurancePR
extends AbstractLanguageAnalyser
implements ProcessingResource {
    private static final long serialVersionUID = 806633306890012316L;
    private String keyASName;
    private String responseASName;
    private List<String> annotationTypes;
    private List<String> featureNames;
    private Measure measure;
    private String measureString;
    private URL outputFolderUrl;
    protected NumberFormat f = NumberFormat.getInstance(Locale.ENGLISH);

    public Resource init() throws ResourceInstantiationException {
        this.f.setMaximumFractionDigits(2);
        this.f.setMinimumFractionDigits(2);
        return this;
    }

    public void execute() throws ExecutionException {
        if (this.corpus == null || this.corpus.size() == 0) {
            throw new ExecutionException("Corpus cannot be null or empty");
        }
        if (this.annotationTypes == null || this.annotationTypes.isEmpty()) {
            throw new ExecutionException("Please provide at least one annotation type to compare");
        }
        if (this.measure == null) {
            throw new ExecutionException("No measure selected");
        }
        Document lastDocument = (Document)this.corpus.get(this.corpus.size() - 1);
        if (lastDocument != this.document) {
            return;
        }
        File outputFolder = null;
        try {
            outputFolder = new File(this.outputFolderUrl.toURI());
            if (!outputFolder.exists()) {
                if (!outputFolder.mkdirs()) {
                    throw new ExecutionException("Could not create a folder : " + outputFolder.getAbsolutePath());
                }
            } else if (!outputFolder.isDirectory()) {
                throw new ExecutionException("Invalid directory : " + outputFolder.getAbsolutePath());
            }
        }
        catch (InvalidURIException iue) {
            throw new ExecutionException((Throwable)iue);
        }
        catch (URISyntaxException use) {
            throw new ExecutionException((Throwable)use);
        }
        switch (this.measure) {
            case F1_STRICT: {
                this.measureString = "f1.0-strict";
                break;
            }
            case F1_LENIENT: {
                this.measureString = "f1.0-lenient";
                break;
            }
            case F1_AVERAGE: {
                this.measureString = "f1.0-average";
                break;
            }
            case F05_STRICT: {
                this.measureString = "f0.5-strict";
                break;
            }
            case F05_LENIENT: {
                this.measureString = "f0.5-lenient";
                break;
            }
            case F05_AVERAGE: {
                this.measureString = "f0.5-average";
            }
        }
        ArrayList<Map<String, AnnotationDiffer>> differsByDocThenType = new ArrayList<Map<String, AnnotationDiffer>>();
        ArrayList<String> documentNames = new ArrayList<String>();
        for (int row = 0; row < this.corpus.size(); ++row) {
            boolean documentWasLoaded = this.corpus.isDocumentLoaded(row);
            Document document = (Document)this.corpus.get(row);
            documentNames.add(document.getName());
            AnnotationSet keys = this.keyASName == null || this.keyASName.trim().length() == 0 ? document.getAnnotations() : document.getAnnotations(this.keyASName);
            AnnotationSet responses = this.responseASName == null || this.responseASName.trim().length() == 0 ? document.getAnnotations() : document.getAnnotations(this.responseASName);
            HashMap<String, AnnotationDiffer> differsByType = new HashMap<String, AnnotationDiffer>();
            HashMap<AnnotationDiffer, List<AnnotationDiffer.Pairing>> pairingsByDiffer = new HashMap<AnnotationDiffer, List<AnnotationDiffer.Pairing>>();
            for (String type : this.annotationTypes) {
                AnnotationSet keyAS = keys.get(type);
                AnnotationSet respAS = responses.get(type);
                AnnotationDiffer differ = new AnnotationDiffer();
                HashSet<String> featuresSet = new HashSet<String>();
                if (this.featureNames != null && !this.featureNames.isEmpty()) {
                    featuresSet.addAll(this.featureNames);
                }
                differ.setSignificantFeaturesSet(new HashSet(featuresSet));
                List pairings = differ.calculateDiff((Collection)keyAS, (Collection)respAS);
                pairingsByDiffer.put(differ, pairings);
                differsByType.put(type, differ);
            }
            differsByDocThenType.add(differsByType);
            AnnotationDiffExporter diffExporter = new AnnotationDiffExporter(pairingsByDiffer, document, this.getKeyASName(), this.getResponseASName());
            try {
                diffExporter.export(this.getDiffResultsExportFile(document.getName()));
                continue;
            }
            catch (IOException e) {
                throw new ExecutionException((Throwable)e);
            }
            finally {
                if (!documentWasLoaded) {
                    this.corpus.unloadDocument(document);
                    Factory.deleteResource((Resource)document);
                }
            }
        }
        String corpusStats = this.calculateCorpusStats(differsByDocThenType);
        String documentStats = this.calculateDocumentStats(documentNames, differsByDocThenType);
        String corpusOutput = "<html><body><b> Corpus Statistics</b><br>" + corpusStats + "<br></body></html>";
        String documentOutput = "<html><body><b> Document Statistics</b><br>" + documentStats + "<br></body></html>";
        BufferedWriter bw = null;
        try {
            bw = new BufferedWriter(new FileWriter(new File(outputFolder, "corpus-stats.html")));
            bw.write(corpusOutput);
            bw.close();
            bw = new BufferedWriter(new FileWriter(new File(outputFolder, "document-stats.html")));
            bw.write(documentOutput);
        }
        catch (IOException ioe) {
            throw new ExecutionException((Throwable)ioe);
        }
        finally {
            if (bw != null) {
                try {
                    bw.close();
                }
                catch (IOException e) {
                    throw new ExecutionException((Throwable)e);
                }
            }
        }
    }

    protected File getDiffResultsExportFile(String documentName) {
        String fileName = documentName.replaceAll("[ ]+", "_") + "-" + this.getKeyASName() + "-" + this.getResponseASName() + "-diff.html";
        return new File(this.getOutputFolderUrl().getFile(), fileName);
    }

    private double[] getMeasureValue(AnnotationDiffer differ, String measure) {
        double[] vals = new double[3];
        vals[0] = measure.endsWith("strict") ? differ.getRecallStrict() : (measure.endsWith("lenient") ? differ.getRecallLenient() : differ.getRecallAverage());
        vals[1] = measure.endsWith("strict") ? differ.getPrecisionStrict() : (measure.endsWith("lenient") ? differ.getPrecisionLenient() : differ.getPrecisionAverage());
        double beta = Double.valueOf(measure.substring(1, measure.indexOf(45)));
        vals[2] = measure.endsWith("strict") ? differ.getFMeasureStrict(beta) : (measure.endsWith("lenient") ? differ.getFMeasureLenient(beta) : differ.getFMeasureAverage(beta));
        return vals;
    }

    private String calculateDocumentStats(List<String> documentNames, List<Map<String, AnnotationDiffer>> differsByDocThenType) throws ExecutionException {
        int row;
        double[] tempvals;
        AnnotationDiffer differ;
        String[] docNames = new String[differsByDocThenType.size() + 2];
        String[] colnames = new String[]{"Document Name", "Match", "Only in Key", "Only in Response", "Overlap", "Rec.B/A", "Prec.B/A", this.measureString};
        double[][] vals = new double[differsByDocThenType.size() + 2][7];
        for (int rowIndex = 0; rowIndex < differsByDocThenType.size(); ++rowIndex) {
            Map<String, AnnotationDiffer> differsByType = differsByDocThenType.get(rowIndex);
            differ = new AnnotationDiffer(differsByType.values());
            docNames[rowIndex] = documentNames.get(rowIndex);
            vals[rowIndex][0] = differ.getCorrectMatches();
            vals[rowIndex][1] = differ.getMissing();
            vals[rowIndex][2] = differ.getSpurious();
            vals[rowIndex][3] = differ.getPartiallyCorrectMatches();
            tempvals = this.getMeasureValue(differ, this.measureString);
            vals[rowIndex][4] = tempvals[0];
            vals[rowIndex][5] = tempvals[1];
            vals[rowIndex][6] = tempvals[2];
        }
        int i = differsByDocThenType.size();
        docNames[i] = "Macro Summary";
        for (row = 0; row < differsByDocThenType.size(); ++row) {
            double[] dArray = vals[i];
            dArray[4] = dArray[4] + vals[row][4];
            double[] dArray2 = vals[i];
            dArray2[5] = dArray2[5] + vals[row][5];
            double[] dArray3 = vals[i];
            dArray3[6] = dArray3[6] + vals[row][6];
        }
        vals[i][4] = vals[i][4] / (double)differsByDocThenType.size();
        vals[i][5] = vals[i][5] / (double)differsByDocThenType.size();
        vals[i][6] = vals[i][6] / (double)differsByDocThenType.size();
        docNames[++i] = "Micro Summary";
        for (row = 0; row < differsByDocThenType.size(); ++row) {
            double[] dArray = vals[i];
            dArray[0] = dArray[0] + vals[row][0];
            double[] dArray4 = vals[i];
            dArray4[1] = dArray4[1] + vals[row][1];
            double[] dArray5 = vals[i];
            dArray5[2] = dArray5[2] + vals[row][2];
            double[] dArray6 = vals[i];
            dArray6[3] = dArray6[3] + vals[row][3];
        }
        ArrayList<AnnotationDiffer> differs = new ArrayList<AnnotationDiffer>();
        for (Map<String, AnnotationDiffer> differsByType : differsByDocThenType) {
            differs.addAll(differsByType.values());
        }
        differ = new AnnotationDiffer(differs);
        tempvals = this.getMeasureValue(differ, this.measureString);
        vals[i][4] = tempvals[0];
        vals[i][5] = tempvals[1];
        vals[i][6] = tempvals[2];
        String[] exportFileNames = new String[docNames.length - 2];
        for (int j = 0; j < exportFileNames.length; ++j) {
            exportFileNames[j] = this.getDiffResultsExportFile(docNames[j]).getName();
        }
        return this.toHtmlTable(docNames, exportFileNames, vals, colnames);
    }

    private String toHtmlTable(String[] firstCol, String[] anchorsOnFirstCol, double[][] vals, String[] columnNames) {
        StringBuffer buffer = new StringBuffer();
        buffer.append("<table>\n");
        buffer.append("\t<tr>\n");
        for (String s : columnNames) {
            buffer.append("\t\t<td>\n");
            buffer.append(s);
            buffer.append("\t\t</td>\n");
        }
        buffer.append("\t</tr>\n");
        for (int i = 0; i < firstCol.length; ++i) {
            double[] colvals;
            buffer.append("\t<tr>\n");
            buffer.append("\t\t<td>\n");
            boolean endAnchor = false;
            if (anchorsOnFirstCol != null && i < anchorsOnFirstCol.length) {
                buffer.append("<a href=\"" + anchorsOnFirstCol[i] + "\">");
                endAnchor = true;
            }
            buffer.append(firstCol[i]);
            if (endAnchor) {
                buffer.append("</a>");
            }
            buffer.append("\t\t</td>\n");
            for (double v : colvals = vals[i]) {
                buffer.append("\t\t<td>\n");
                buffer.append(this.f.format(v));
                buffer.append("\t\t</td>\n");
            }
            buffer.append("\t</tr>\n");
        }
        buffer.append("</table>");
        return buffer.toString();
    }

    private String calculateCorpusStats(List<Map<String, AnnotationDiffer>> differsByDocThenType) {
        int row;
        String[] typesNames = new String[this.annotationTypes.size() + 2];
        String[] colnames = new String[]{"Annotation Type", "Match", "Only in Key", "Only in Response", "Overlap", "Rec.B/A", "Prec.B/A", this.measureString};
        double[][] vals = new double[this.annotationTypes.size() + 2][7];
        for (int rowIndex = 0; rowIndex < this.annotationTypes.size(); ++rowIndex) {
            String type = this.annotationTypes.get(rowIndex);
            ArrayList<AnnotationDiffer> differs = new ArrayList<AnnotationDiffer>();
            for (Map<String, AnnotationDiffer> differsByType : differsByDocThenType) {
                differs.add(differsByType.get(type));
            }
            AnnotationDiffer differ = new AnnotationDiffer(differs);
            typesNames[rowIndex] = type;
            vals[rowIndex][0] = differ.getCorrectMatches();
            vals[rowIndex][1] = differ.getMissing();
            vals[rowIndex][2] = differ.getSpurious();
            vals[rowIndex][3] = differ.getPartiallyCorrectMatches();
            double[] tempvals = this.getMeasureValue(differ, this.measureString);
            vals[rowIndex][4] = tempvals[0];
            vals[rowIndex][5] = tempvals[1];
            vals[rowIndex][6] = tempvals[2];
        }
        int i = this.annotationTypes.size();
        typesNames[i] = "Macro Summary";
        for (row = 0; row < this.annotationTypes.size(); ++row) {
            double[] dArray = vals[i];
            dArray[4] = dArray[4] + vals[row][4];
            double[] dArray2 = vals[i];
            dArray2[5] = dArray2[5] + vals[row][5];
            double[] dArray3 = vals[i];
            dArray3[6] = dArray3[6] + vals[row][6];
        }
        vals[i][4] = vals[i][4] / (double)this.annotationTypes.size();
        vals[i][5] = vals[i][5] / (double)this.annotationTypes.size();
        vals[i][6] = vals[i][6] / (double)this.annotationTypes.size();
        typesNames[++i] = "Micro Summary";
        for (row = 0; row < this.annotationTypes.size(); ++row) {
            double[] dArray = vals[i];
            dArray[0] = dArray[0] + vals[row][0];
            double[] dArray4 = vals[i];
            dArray4[1] = dArray4[1] + vals[row][1];
            double[] dArray5 = vals[i];
            dArray5[2] = dArray5[2] + vals[row][2];
            double[] dArray6 = vals[i];
            dArray6[3] = dArray6[3] + vals[row][3];
        }
        ArrayList<AnnotationDiffer> differs = new ArrayList<AnnotationDiffer>();
        for (Map<String, AnnotationDiffer> differsByType : differsByDocThenType) {
            differs.addAll(differsByType.values());
        }
        AnnotationDiffer differ = new AnnotationDiffer(differs);
        double[] tempvals = this.getMeasureValue(differ, this.measureString);
        vals[i][4] = tempvals[0];
        vals[i][5] = tempvals[1];
        vals[i][6] = tempvals[2];
        return this.toHtmlTable(typesNames, null, vals, colnames);
    }

    public String getKeyASName() {
        return this.keyASName;
    }

    @RunTime
    @Optional
    @CreoleParameter(defaultValue="Key")
    public void setKeyASName(String keyASName) {
        this.keyASName = keyASName;
    }

    public String getResponseASName() {
        return this.responseASName;
    }

    @Optional
    @RunTime
    @CreoleParameter(defaultValue="")
    public void setResponseASName(String responseASName) {
        this.responseASName = responseASName;
    }

    public List<String> getAnnotationTypes() {
        return this.annotationTypes;
    }

    @RunTime
    @CreoleParameter
    public void setAnnotationTypes(List<String> annotationTypes) {
        this.annotationTypes = annotationTypes;
    }

    public List<String> getFeatureNames() {
        return this.featureNames;
    }

    @RunTime
    @Optional
    @CreoleParameter
    public void setFeatureNames(List<String> featureNames) {
        this.featureNames = featureNames;
    }

    public Measure getMeasure() {
        return this.measure;
    }

    @RunTime
    @CreoleParameter
    public void setMeasure(Measure measure) {
        this.measure = measure;
    }

    public URL getOutputFolderUrl() {
        return this.outputFolderUrl;
    }

    @RunTime
    @CreoleParameter(suffixes="html")
    public void setOutputFolderUrl(URL outputFolderUrl) {
        this.outputFolderUrl = outputFolderUrl;
    }
}

