/*
 * Decompiled with CFR 0.152.
 */
package info.semanticsoftware.lodtagger;

import com.google.gson.Gson;
import gate.AnnotationSet;
import gate.Factory;
import gate.FeatureMap;
import gate.ProcessingResource;
import gate.Resource;
import gate.creole.AbstractLanguageAnalyser;
import gate.creole.ExecutionException;
import gate.creole.ResourceInstantiationException;
import gate.creole.metadata.CreoleParameter;
import gate.creole.metadata.CreoleResource;
import gate.creole.metadata.RunTime;
import gate.util.InvalidOffsetException;
import info.semanticsoftware.lodtagger.model.SpotlightResource;
import info.semanticsoftware.lodtagger.model.SpotlightResult;
import java.io.BufferedReader;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLEncoder;
import java.nio.charset.Charset;
import java.util.List;

@CreoleResource(name="DBpediaTagger", comment="Transforms DBpedia Spotlight response objects to GATE annotations.")
public class DBpediaTagger
extends AbstractLanguageAnalyser
implements ProcessingResource {
    private static final long serialVersionUID = 1L;
    private static int HTTP_OK = 200;
    @CreoleParameter(comment="Output annotation name", defaultValue="DBpediaLink")
    @RunTime
    private String outputAnnotationName;
    @CreoleParameter(comment="Spotlight endpoint URL", defaultValue="http://localhost:2222/rest/annotate")
    @RunTime
    private String endpoint;
    @CreoleParameter(comment="Confidence", defaultValue="0.1")
    @RunTime
    private Double confidence = 0.1;
    @CreoleParameter(comment="Support", defaultValue="10")
    @RunTime
    private Integer support = 10;
    @CreoleParameter(comment="outputASName", defaultValue="")
    @RunTime
    private String outputASName = "";

    public final String getOutputAnnotationName() {
        return this.outputAnnotationName;
    }

    public final void setOutputAnnotationName(String string) {
        this.outputAnnotationName = string;
    }

    public final String getEndpoint() {
        return this.endpoint;
    }

    public final void setEndpoint(String string) {
        this.endpoint = string;
    }

    public final Double getConfidence() {
        return this.confidence;
    }

    public final void setConfidence(Double d) {
        this.confidence = d;
    }

    public final Integer getSupport() {
        return this.support;
    }

    public final void setSupport(Integer n) {
        this.support = n;
    }

    public final String getOutputASName() {
        return this.outputASName;
    }

    public final void setOutputASName(String string) {
        this.outputASName = string;
    }

    public Resource init() throws ResourceInstantiationException {
        return this;
    }

    public void reInit() throws ResourceInstantiationException {
        this.init();
    }

    public void execute() throws ExecutionException {
        String string = this.document.getContent().toString();
        SpotlightResult spotlightResult = this.callSpotlight(string);
        List<SpotlightResource> list = spotlightResult.getResources();
        AnnotationSet annotationSet = this.document.getAnnotations(this.outputASName);
        for (SpotlightResource spotlightResource : list) {
            FeatureMap featureMap = Factory.newFeatureMap();
            featureMap.put((Object)"URI", (Object)spotlightResource.getURI());
            featureMap.put((Object)"similarityScore", (Object)spotlightResource.getSimilarityScore());
            if (spotlightResource.getSurfaceForm() == null) {
                spotlightResource.setSurfaceForm("null");
            }
            long l = spotlightResource.getOffset() + (long)spotlightResource.getSurfaceForm().length();
            try {
                annotationSet.add(Long.valueOf(spotlightResource.getOffset()), Long.valueOf(l), this.getOutputAnnotationName(), featureMap);
            }
            catch (InvalidOffsetException invalidOffsetException) {
                invalidOffsetException.printStackTrace();
            }
        }
    }

    private SpotlightResult callSpotlight(String string) {
        try {
            URL uRL = new URL(this.endpoint);
            HttpURLConnection httpURLConnection = (HttpURLConnection)uRL.openConnection();
            httpURLConnection.setRequestMethod("POST");
            httpURLConnection.setRequestProperty("Accept", "application/json");
            httpURLConnection.setRequestProperty("content-type", "application/x-www-form-urlencoded");
            String string2 = "text=" + URLEncoder.encode(string, "UTF-8") + "&confidence=" + this.confidence + "&support" + this.support;
            httpURLConnection.setDoOutput(true);
            DataOutputStream dataOutputStream = new DataOutputStream(httpURLConnection.getOutputStream());
            dataOutputStream.writeBytes(string2);
            dataOutputStream.flush();
            dataOutputStream.close();
            if (httpURLConnection.getResponseCode() != HTTP_OK) {
                throw new RuntimeException("Failed: Http error code " + httpURLConnection.getResponseCode());
            }
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(httpURLConnection.getInputStream(), Charset.forName("UTF-8")));
            Gson gson = new Gson();
            return (SpotlightResult)gson.fromJson((Reader)bufferedReader, SpotlightResult.class);
        }
        catch (MalformedURLException malformedURLException) {
            malformedURLException.printStackTrace();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        return null;
    }
}

